<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

?>
<!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js no-svg">

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link href="<?php echo get_stylesheet_directory_uri(); ?>/css/bootstrap.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo get_stylesheet_directory_uri(); ?>/css/style.css" rel="stylesheet" type="text/css">
	<link href="<?php echo get_stylesheet_directory_uri(); ?>/css/font-awesome.min.css" rel="stylesheet" type="text/css">
	<link href="<?php echo get_stylesheet_directory_uri(); ?>/css/stellarnav.css" rel="stylesheet" type="text/css">
	<link href="<?php echo get_stylesheet_directory_uri(); ?>/css/animate.css" rel="stylesheet" type="text/css">
	<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/css/owl.carousel.min.css" type="text/css">
	<link rel="stylesheet" href="<?php echo get_stylesheet_directory_uri(); ?>/css/owl.theme.default.min.css" type="text/css">
	<link href="<?php echo get_stylesheet_directory_uri(); ?>/css/responsive.css" rel="stylesheet" type="text/css">
	<link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
	<header>
		<div class="container">
			<div class="row clearfix">
				<div class="col-md-3">
					<?php
					$custom_logo_id = get_theme_mod( 'custom_logo' );
					$logo = wp_get_attachment_image_src( $custom_logo_id, 'full' );
					?>
					<div class="logo"><a href="<?php echo get_site_url();?>"><img src="<?php echo $logo[0];?>" alt="<?php echo get_bloginfo( 'name' ) ;?>"></a>
					</div>
				</div>
				<div class="col-md-9">
					<div class="top_header_links">
						<ul>
							<?php 
			  $current_user = wp_get_current_user();
							
			  if($current_user->user_login == ''){
				  ?>
							<li><a href="<?php echo get_site_url()?>/broker-login/">Brokers</a>
							</li>
							<li><a href="<?php echo get_site_url()?>/client-login/">Client Login</a>
							</li>
							<?php
							} else {
								if ( in_array( 'broker', ( array )$current_user->roles ) || in_array( 'administrator', ( array )$current_user->roles )) {
									?>
							<li><a href="<?php echo get_site_url()?>/broker/">Dashboard</a>
							</li>
							<li><a href="<?php echo get_site_url()?>/logout">Logout</a>
							</li>
							<?php
							} else if ( in_array( 'client', ( array )$current_user->roles ) ) {
								?>
							<li><a href="<?php echo get_site_url()?>/client-account">Dashboard</a>
							</li>
							<li><a href="<?php echo get_site_url()?>/logout">Logout</a>
							</li>
							<?php
							}
							}
							?>

							<?php
							$phone_no = ot_get_option( 'phone_number' );
							$phone_no_format = str_replace( array( '(', ')', '.', '-', ' ' ), '', $phone_no );
							?>
							<li><a href="tel:<?php echo $phone_no_format;?>"><span><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/call-icon.png" alt="icon"></span><?php echo $phone_no;?></a>
							</li>
						</ul>
					</div>
					<div id="main-nav" class="stellarnav">
						<?php wp_nav_menu( array('menu' => 'Top Menu', 'container' => false,) );?>
					</div>
					<!-- .stellar-nav -->
				</div>
			</div>
		</div>
	</header>
	<?php if(!is_front_page()){ 
	$featured_image = get_field('inner_banner_image');
	if($featured_image){
		$featured_image_url = $featured_image['url'];
	}else{
		$featured_image_url = get_stylesheet_directory_uri().'/images/about-creditier-bg.jpg';
	}
	?>
	<div class="fixed-banner" style="background: url(<?php echo $featured_image_url;?>) no-repeat;" title="<?php echo $featured_image['alt'];?>">
		<div class="container">
			<div class="row clearfix">
				<div class="col-md-12">
					<div class="banner-heading wow fadeInDown">
						<h2>						
							<?php if(is_404()){ echo "404 Page Not Found!";}else{the_title();}?>
						</h2>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="breadcrumb_sec">
		<div class="container">
			<div class="row">
				<nav aria-label="breadcrumb">
					<ol class="breadcrumb">
						<li class="breadcrumb-item"><a href="<?php echo get_site_url();?>">Home</a>
						</li>
						<li class="breadcrumb-item" aria-current="page">
							<?php if(is_404()){ echo "404 Page Not Found!";}else{the_title();}?>
						</li>
					</ol>
				</nav>
			</div>
		</div>
	</div>
	<?php }
	
	?>