<?php
/**
 * The front page template file
 *
 * If the user has selected a static page for their homepage, this is what will
 * appear.
 * Learn more: https://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Seventeen
 * @since 1.0
 * @version 1.0
 */

get_header(); emailsubscriber();?>
<div class="home_slider">
  <div id="bigslide" class="owl-carousel owl-theme">
  <?php $hslider_args = array(
                      'post_type'   =>  'home-slider',
                      'posts_per_page'   =>  -1,
                            );
		$hslider_query = new WP_Query( $hslider_args );
		while ( $hslider_query->have_posts() ) : $hslider_query->the_post(); ?>
    <div class="item"> 
      <div class="banner_caption">
        <div class="container">
          <div class="row clearfix">
            <div class="col-md-6 col-sm-6 right_text pull-right"> <img src="<?php echo get_stylesheet_directory_uri(); ?>/images/banner-img.png" alt="">
              <h5 class="wow fadeInDown"><?php the_field('content');?></h5>
              <p class="wow flipInX"><?php the_field('bottom_content');?></p>
            </div>
            <div class="col-md-6 col-sm-6 left_text">
              <h2 class="wow flipInY"><?php the_field('banner_heading');?></h2>
              <h3 class="wow bounceIn"><?php the_field('banner_sub_heading');?></h3>
              <a href="<?php the_field('free_tips_link');?>" class="btn btn-freetips wow bounceIn">Free Tips<span><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/right-arrow.png" alt=""></span></a> <a href="<?php the_field('signup_link');?>" class="btn btn-signup wow bounceIn">Signup Now<span><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/right-arrow.png" alt=""></span></a> </div>
          </div>
        </div>
      </div>
    </div>
				  <?php endwhile; wp_reset_query();?>
    
  </div>
</div>
<div class="excellent_credit">
  <div class="container">
    <div class="row clearfix">
      <div class="excredit_left wow fadeInDown">
        <?php the_field('newsletter_heading');?> </div>
      <div class="excredit_right">
        <div class="row">
          <form class="clearfix" action="" method="POST">
            <div class="col-md-4 col-sm-4">
              <div class="form-group wow fadeInDown">
                <input type="text" placeholder="Full Name" required name="f_name_subs" class="form-control">
              </div>
            </div>
            <div class="col-md-4 col-sm-4">
              <div class="form-group wow fadeInDown">
                <input type="text" placeholder="Phone"  name="phone_subs"  class="form-control">
              </div>
            </div>
            <div class="col-md-4 col-sm-4">
              <div class="form-group wow fadeInDown">
                <input type="email" placeholder="Email" required name="email_subs"  class="form-control">
              </div>
            </div>
            <div class="col-md-4 col-sm-4">
              <div class="form-group wow fadeInDown">
                <p>Would you like a free credit review?</p>
              </div>
            </div>
            <div class="col-md-4 col-sm-4">
              <div class="form-group wow fadeInDown">
                <div class="radiobutton">
                  <input type="radio" name="radios" name="credit_subs" value="Yes" id="radio_1"/>
                  <label for="radio_1">Yes</label>
                </div>
                <div class="radiobutton">
                  <input type="radio" name="radios" name="credit_subs" value="No" id="radio_2"/>
                  <label for="radio_2">No</label>
                </div>
              </div>
            </div>
            <div class="col-md-4 col-sm-4">
              <div class="form-group wow fadeInDown">
                <button type="submit" class="btn btn-warning btn-block" name="submit_news_letter">GET STARTED</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="credit_services">
  <div class="container">
    <div class="row clearfix">
      <div class="col-md-12">
        <div class="service_heading">
          <h2 class="wow bounceIn"><?php the_field('los_angeles_title');?></h2>
        </div>
        <div class="servicelist">
          <ul>
            <li class="wow fadeInDown"> <span class="listimg_01"></span> <span class="servicename"><?php the_field('los_angeles_1_logo_title');?></span> </li>
            <li class="wow fadeInDown"> <span class="listimg_02"></span> <span class="servicename"><?php the_field('los_angeles_2_logo_title');?></span> </li>
            <li class="wow fadeInDown"> <span class="listimg_03"></span> <span class="servicename"><?php the_field('los_angeles_3_logo_title');?></span> </li>
            <li class="wow fadeInDown"> <span class="listimg_04"></span> <span class="servicename"><?php the_field('los_angeles_4_logo_title');?></span> </li>
            <li class="wow fadeInDown"> <span class="listimg_05"></span> <span class="servicename"><?php the_field('los_angeles_5_logo_title');?></span> </li>
            <li class="wow fadeInDown"> <span class="listimg_06"></span> <span class="servicename"><?php the_field('los_angeles_6_logo_title');?></span> </li>
          </ul>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="about_creditier">
  <div class="container">
    <div class="row clearfix">
      <div class="col-md-12">
        <div class="about_box">
          <h2 class="wow bounceIn"><?php the_field('about_creditier_heading');?></h2>
          <h3 class="wow fadeInDown"><?php the_field('about_creditier_sub_heading');?></h3>
          <p class="wow fadeInDown"><?php the_field('about_creditier_content');?></p>
          <a href="<?php the_field('about_creditier_know_more_link');?>" class="btn-knowmore wow bounceIn">Know More<span><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/right-arrow.png" alt=""></span></a> </div>
      </div>
    </div>
  </div>
</div>
<div class="grey_box_content">
  <div class="container">
    <div class="row clearfix">
      <div class="col-md-6 col-sm-6">
        <div class="grey_box_holder bluecolor_box">
          <div class="box_heading wow fadeInDown"> <span><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/icon1.png" alt=""></span>
            <h2><?php the_field('service_1_title');?></h2>
            <p><?php the_field('service_1_sub_heading');?></p>
          </div>
          <div class="content_box wow fadeInDown">
            <?php the_field('service_1_content');?>
          </div>
          <div class="plan_box">
            <ul>
              <?php the_field('service_1_package_1');?>
              <?php the_field('service_1_package_2');?>
              <?php the_field('service_1_package_3');?>
              <?php the_field('service_1_package_4');?>
            </ul>
          </div>
          <div class="get_started"> <a href="<?php the_field('select_1_service');?>" class="btn btn-default wow bounceIn">GET STARTED</a>
            <?php the_field('service_1_bottom_content');?>
          </div>
        </div>
      </div>
      <div class="col-md-6 col-sm-6">
        <div class="grey_box_holder yellow_box">
          <div class="box_heading wow fadeInDown"> <span><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/icon2.png" alt=""></span>
            <h2><?php the_field('service_2_title');?></h2>
            <p> <?php the_field('service_2_sub_heading');?></p>
          </div>
          <div class="content_box wow fadeInDown">
            <?php the_field('service_2_points_');?>
          </div>
          <div class="get_started"> <a href="<?php the_field('select_2_service');?>" class="btn btn-default  wow bounceIn">GET STARTED</a>
            <?php the_field('service_2_bottom_content');?>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="grey_box_content">
  <div class="container">
    <div class="row clearfix">
      <div class="col-md-6 col-sm-6">
        <div class="grey_box_holder violetcolor_box">
          <div class="box_heading wow fadeInDown"> <span><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/icon3.png" alt=""></span>
            <h2><?php the_field('service_3_title');?></h2>
            <p><?php the_field('service_3_sub_heading');?></p>
          </div>
          <?php the_field('service_3_points');?>
          <div class="get_started"> <a href="<?php the_field('select_3_service');?>" class="btn btn-default wow bounceIn">GET STARTED</a>
            <p><?php the_field('service_3_bottom_content');?></p>
          </div>
        </div>
      </div>
      <div class="col-md-6 col-sm-6">
        <div class="grey_box_holder green_box">
          <div class="box_heading wow fadeInDown"> <span><img src="<?php echo get_stylesheet_directory_uri(); ?>/images/icon4.png" alt=""></span>
            <h2><?php the_field('service_4_title');?></h2>
            <p><?php the_field('service_4_sub_heading');?></p>
          </div>
          <div class="content_box wow fadeInDown">
           <?php the_field('service_4_points');?>
          </div>
          <div class="get_started"> <a href="<?php the_field('select_4_service');?>" class="btn btn-default wow bounceIn">GET STARTED</a>
            <p><?php the_field('service_4_bottom_content');?></p>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php get_footer();
