<?php
/**
 * Template Name: Contact Page
 */

get_header();
?>
<?php while ( have_posts() ) : the_post();?>
<div class="page-inner">
  <div class="container">
    <div class="row clearfix">
      <div class="col-md-6 col-sm-6">
        <div class="contact_left">
          <h2 class="contact-heading wow fadeInLeft">Contact Information</h2>
          <ul>
            <li> <i class="fa fa-map-marker" aria-hidden="true"></i>
              <h3>Address:</h3>
              <p><?php the_field('address');?></p>
            </li>
            <li> <i class="fa fa-phone" aria-hidden="true"></i>
              <h3>Phone:</h3>
             <?php $phone_no_c = get_field('phone_number');
				$phone_no_format_c = str_replace( array( '(', ')', '.','-','+', ' ' ), '', $phone_no_c ); ?>
              <a href="tel:<?php echo $phone_no_format_c;?>"><?php the_field('phone_number');?></a> </li>
            <li> <i class="fa fa-envelope" aria-hidden="true"></i>
              <h3>Email:</h3>
              <a href="mailto:<?php the_field('email_address');?>"><?php the_field('email_address');?></a> </li>
          </ul>
          <div class="map_area">
            <?php the_field('map_iframe');?>
          </div>
        </div>
      </div>
      <div class="col-md-6 col-sm-6">
        <div class="contact_right wow fadeInRight">
          <h2 class="contact-heading">Get In Touch</h2>
          <?php echo do_shortcode( '[contact-form-7 id="5" title="Contact form"]' );?>
        </div>
      </div>
    </div>
  </div>
</div>
<?php endwhile;?>
<?php get_footer(); ?>